# -*- coding: utf-8 -*- 
# http://scipy-lectures.github.com


#---------------------------------------------------
#Import důležitých součástí
#---------------------------------------------------
import numpy as np
import scipy as sp
import pylab as plt
from scipy import signal
from scipy import io as soubory
import matplotlib as mat

import SumNaPozadi_functions as SnP
import Bunka_functions as Bunka
import Hmotnost_functions as Hmot

def KorekceSumuVBode(MaskaVBode, BunkaVBode, PocetCyklu):
    CasPrekryvu = 0
    Predchozi = 0
    SumyVBode = np.zeros(PocetCyklu+2)
    for i in range(0, PocetCyklu+2, 1):
        if MaskaVBode[i] == 1:    # pokud na zkoumaném bodě bunka v tento okamžik je
            if Predchozi == 0:    # ale minulý okamžik ještě nebyla
               # uložení první hodnoty (ze 2) pro výpočet interpolovaného šumu
               PrvniHodnota = BunkaVBode[i-1]
               Predchozi = 1
            CasPrekryvu = CasPrekryvu + 1
        else:                       # pokud na zkoumaném bodě bunka v tento okamžik není
            if Predchozi == 1:      # ale v předchozí okamžik se tu nacházela
                # uložení druhé hodnoty (ze 2) pro výpočet interpolovaného šumu
                PosledniHodnota = BunkaVBode[i]
                InterpolovanySum = np.linspace(PrvniHodnota, PosledniHodnota, (CasPrekryvu+2)) #výpočet interpolovaného šumu
                SumyVBode[(i+1-(CasPrekryvu+2)):(i+1)] = InterpolovanySum
                Predchozi = 0
                CasPrekryvu = 0
                InterpolovanySum = 0
            else:
                # je-li ve zkoumaném bodě šum, nahraje se do matice šumu jednoduše tento šum
                SumyVBode[i] = BunkaVBode[i]
    BodBezSumu = BunkaVBode - SumyVBode    # výpočet opraveného bodu
    return BodBezSumu